<?php
session_start();

// Verificar si el usuario está logueado
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}

// Conectar a la base de datos
require_once 'conexiones/conexion.php';
require_once 'solicitudes/email_usuario_conectado.php';
// Librería para generar el código QR
require_once 'phpqrcode/qrlib.php';

$error = '';
$success = '';
$ticket_data = [];
$cliente_nombre = '';

// Obtener los tipos de ticket desde la base de datos
$stmt = $pdo->prepare("SELECT nombre FROM ticket_tipo");
$stmt->execute();
$tipos_ticket = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Obtener las opciones de validez desde la configuración
$stmt = $pdo->prepare("SELECT validez_ticket FROM configuracion");
$stmt->execute();
$validez_ticket_options = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Obtener el precio del ticket desde la configuración
$stmt = $pdo->prepare("SELECT precio_ticket FROM configuracion");
$stmt->execute();
$precio_ticket_data = $stmt->fetch(PDO::FETCH_ASSOC);
$precio_ticket = $precio_ticket_data['precio_ticket'] ?? 0;

// Procesar el formulario
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $cliente_tipo = $_POST['cliente_tipo'];
    $dni = $_POST['dni'] ?? '';

    // Verificar el tipo de cliente y obtener el nombre
    if ($cliente_tipo === 'consumidor_final') {
        $cliente_nombre = 'Consumidor Final';
    } else {
        // Buscar el nombre del cliente en la base de datos por DNI
        $stmt = $pdo->prepare("SELECT nombre FROM clientes WHERE dni = ?");
        $stmt->execute([$dni]);
        $cliente = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($cliente) {
            $cliente_nombre = $cliente['nombre'];
        } else {
            $error = "No se encontró un cliente con el DNI proporcionado.";
            echo "<script>alert('$error');</script>";
        }
    }

    $tipo_ticket = $_POST['tipo_ticket'];
    $validez_ticket = $_POST['validez_ticket'];
    // traemos el email desde email_usuario_conectado.php.
    $usuario_venta = $result['email'] ?? 'desconocido'; 

    $precio = $precio_ticket; // Usamos el precio desde la configuración

    // Validar los datos
    if (empty($cliente_tipo) || empty($tipo_ticket) || empty($validez_ticket) || empty($precio) || empty($cliente_nombre)) {
        $error = "Todos los campos son obligatorios.";
    } else {
        // Generar un código único para el ticket
        $codigo_ticket = uniqid('ticket_');

        // Insertar el ticket en la base de datos
        $stmt = $pdo->prepare("INSERT INTO tickets (cliente_nombre, tipo_ticket, validez_ticket, precio, codigo_ticket, usuario_venta) VALUES (?, ?, ?, ?, ?, ?)");
        $stmt->execute([$cliente_nombre, $tipo_ticket, $validez_ticket, $precio, $codigo_ticket, $usuario_venta]);

        // Crear una cadena con toda la información del ticket
        $ticket_info = "$codigo_ticket";

        // Generar el código QR con toda la información
        $qr_code_file = 'qrs/' . $codigo_ticket . '.png';
        QRcode::png($ticket_info, $qr_code_file);

        // Guardar los datos del ticket para mostrarlos en el modal
        $ticket_data = [
            'cliente_nombre' => $cliente_nombre,
            'tipo_ticket' => $tipo_ticket,
            'validez_ticket' => $validez_ticket,
            'precio' => $precio,
            'codigo_ticket' => $codigo_ticket,
            'qr_code_file' => $qr_code_file
        ];
        $success = "Ticket generado con éxito.";
    }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Generar Ticket</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
   <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
</head>
<body>
 <?php 
    include "menuajuste.php";
  ?>


    <div class="content">
        <h1 class="text-center mb-4">Generar Ticket</h1>

        <?php if (!empty($error)) { echo "<div class='error'>$error</div>"; } ?>
        <?php if (!empty($success)) { echo "<div class='success'>$success</div>"; } ?>

        <!-- Formulario -->
        <form action="generar_ticket.php" method="POST">
            <div class="mb-3">
                <label for="cliente_tipo" class="form-label">Tipo de Cliente</label>
                <select class="form-select" id="cliente_tipo" name="cliente_tipo" required>
                    <option value="consumidor_final">Consumidor Final</option>
                    <option value="cliente">Cliente</option>
                </select>
            </div>
            <div class="mb-3" id="dni_container" style="display: none;">
                <label for="dni" class="form-label">DNI del Cliente</label>
                <input type="text" class="form-control" id="dni" name="dni">
                <button type="button" class="btn btn-secondary mt-2" id="verificar_dni">Verificar</button>
                <div id="cliente_nombre" class="mt-2"></div>
            </div>
            <div class="mb-3">
                <label for="tipo_ticket" class="form-label">Tipo de Ticket</label>
                <select class="form-select" id="tipo_ticket" name="tipo_ticket" required>
                    <?php foreach ($tipos_ticket as $tipo): ?>
                        <option value="<?= htmlspecialchars($tipo['nombre']) ?>"><?= htmlspecialchars($tipo['nombre']) ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="mb-3">
                <label for="validez_ticket" class="form-label">Validez del Ticket</label>
                <select class="form-select" id="validez_ticket" name="validez_ticket" required>
                    <?php foreach ($validez_ticket_options as $option): ?>
                    	 <option value="<?= htmlspecialchars($option['validez_ticket']) ?>"><?= htmlspecialchars($option['validez_ticket']) ?></option>
                    	<option value="1 horas">1 horas</option>
                    	<option value="1 horas">2 horas</option>
                    	<option value="3 horas">3 horas</option>
                    	<option value="4 horas">4 horas</option>
                    	<option value="5 horas">5 horas</option>
                    	<option value="6 horas">6 horas</option>
                    	<option value="7 horas">7 horas</option>
                    	<option value="8 horas">8 horas</option>
                    	<option value="9 horas">9 horas</option>
                    	<option value="10 horas">10 horas</option>
                    	<option value="11 horas">11 horas</option>
                       
                    <?php endforeach; ?>
                    <option value="indefinido">Tiempo Indefinido</option>
                </select>
            </div>
            <div class="mb-3">
                <label for="precio" class="form-label">Precio</label>
                <input type="text" class="form-control" id="precio" name="precio" value="<?= htmlspecialchars($precio_ticket) ?>" readonly>
            </div>
            <div class="d-grid mt-3">
                <button type="submit" class="btn btn-primary">Generar Ticket</button>
            </div>
        </form>

        <!-- Modal para mostrar el ticket -->
        <?php if (!empty($ticket_data)) { ?>
        <div class="modal fade show d-block" tabindex="-1" role="dialog" id="ticketModal">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Comprobante de Ticket</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" id="closeModal"></button>
                    </div>
                    <div class="modal-body">
                        <p><strong>Nombre del Cliente:</strong> <?= htmlspecialchars($ticket_data['cliente_nombre']) ?></p>
                        <p><strong>Tipo de Ticket:</strong> <?= htmlspecialchars($ticket_data['tipo_ticket']) ?></p>
                        <p><strong>Validez del Ticket:</strong> <?= htmlspecialchars($ticket_data['validez_ticket']) ?></p>
                        <p><strong>Precio:</strong> <?= htmlspecialchars($ticket_data['precio']) ?></p>
                        <p><strong>Código de Ticket:</strong> <?= htmlspecialchars($ticket_data['codigo_ticket']) ?></p>
                        <img src="<?= $ticket_data['qr_code_file'] ?>" alt="Código QR" class="img-fluid">
                    </div>
                    <div class="modal-footer">
                        <a href="generar_ticket_pdf.php?codigo_ticket=<?= $ticket_data['codigo_ticket'] ?>" class="btn btn-primary" target="_blank">Generar PDF</a>
                      <a href="generar_ticket.php"> <button type="button" class="btn btn-secondary" data-bs-dismiss="modal" id="closeModal">Cerrar</button></a> 
                    </div>
                </div>
            </div>
        </div>
        <?php } ?>

    </div>

<script>
     // Mostrar u ocultar el campo de DNI según el tipo de cliente
    document.getElementById('cliente_tipo').addEventListener('change', function () {
        const isCliente = this.value === 'cliente';
        document.getElementById('dni_container').style.display = isCliente ? 'block' : 'none';
    });

    // Verificar DNI
    document.getElementById('verificar_dni').addEventListener('click', function () {
        const dni = document.getElementById('dni').value;
        if (dni) {
            fetch('verificar_cliente.php?dni=' + dni)
                .then(response => response.json())
                .then(data => {
                    if (data.found) {
                        document.getElementById('cliente_nombre').innerHTML = 'Nombre: ' + data.nombre;
                    } else {
                        var myModal = new bootstrap.Modal(document.getElementById('cliente_no_encontrado_modal'));
                        myModal.show();
                    }
                });
        }
    });

    document.addEventListener('DOMContentLoaded', function() {
        // Inicializar el modal de Bootstrap de manera adecuada
        const ticketModalElement = document.getElementById('ticketModal');
        const closeModalBtn = document.getElementById('closeModal');
        
        // Verificar si el modal y el botón de cerrar existen
        if (ticketModalElement && closeModalBtn) {
            // Crear una instancia del modal
            const ticketModal = new bootstrap.Modal(ticketModalElement);

            // Agregar el evento para cerrar el modal
            closeModalBtn.addEventListener('click', function() {
                ticketModal.hide();  // Cerrar el modal
              window.location.href = "generar_ticket.php";  // Redirigir a la página generar_ticket.php
            });

            // Mostrar el modal (si es necesario)
            ticketModal.show();
        }
    });
</script>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
